import math

# Tworzenie tablicy pomocniczej zawierającej wyniki mnożenia wszystkich cyfr:
MULT_TABLE = {}
for i in range(10):
    for j in range(10):
        MULT_TABLE[(i, j)] = i * j

def padZeros(numberString, numZeros, insertSide):
    """ Funkcja zwraca łańcuch znaków uzupełniony zerami z lewej lub prawej strony"""
    if insertSide == 'left':
        return '0' * numZeros + numberString
    elif insertSide == 'right':
        return numberString + '0' * numZeros

def karatsuba(x, y):
    """Mnożenie dwóch liczb całkowitych za pomocą algorytmu Karacuby.
    Zauważ, że w tej funkcji nigdzie nie korzystam z operatora *"""
    assert isinstance(x, int), 'x musi być całkowite'
    assert isinstance(y, int), 'y musi być całkowite'
    x = str(x)
    y = str(y)

    # W przypadku jednocyfrowej liczby sprawdzamy wynik w tablicy pomocniczej:
    if len(x) == 1 and len(y) == 1: # PRZYPADEK BAZOWY
        print('Sprawdzam w tablicy pomocniczej wynik mnożenia', x, '*', y, '=', MULT_TABLE[(int(x), int(y))])
        return MULT_TABLE[(int(x), int(y))]

    # PRZYPADEK REKURENCYJNY
    print('Mnożę', x, '*', y)

    # Uzupełnianie zerami, tak aby x i y miały tę sąmą długość:
    if len(x) < len(y):
        # Jeżeli x jest krótsze od y, uzupełniam x zerami:
        x = padZeros(x, len(y) - len(x), 'left')
    elif len(y) < len(x):
        # Jeżeli y jest krótsze od x, uzupełniam y zerami:
        y = padZeros(y, len(x) - len(y), 'left')
    # W tym punkcie x i y mają taką samą długość.

    halfOfDigits = math.floor(len(x) / 2)

    # Dzielenie x na a i b oraz y na c i d:
    a = int(x[:halfOfDigits])
    b = int(x[halfOfDigits:])
    c = int(y[:halfOfDigits])
    d = int(y[halfOfDigits:])

    # Wywołania rekurencyjne na otrzymanych fragmentach liczb:
    step1Result = karatsuba(a, c) # Krok 1.: Mnożenie a i c.
    step2Result = karatsuba(b, d) # Krok 2.: Mnożenie b i d.
    step3Result = karatsuba(a + b, c + d) # Krok 3.: Mnożenie a + b i c + d.

    # Krok 4.: Obliczanie różnicy wyników z kroku 3., 2. i 1.:
    step4Result = step3Result - step2Result - step1Result

    # Krok 5.: Uzupełnienia łańcuchów znaków zerami, dodanie do siebie wyników i zwrócenie wartości:
    step1Padding = (len(x) - halfOfDigits) + (len(x) - halfOfDigits)
    step1PaddedNum = int(padZeros(str(step1Result), step1Padding, 'right'))

    step4Padding = (len(x) - halfOfDigits)
    step4PaddedNum = int(padZeros(str(step4Result), step4Padding, 'right'))

    print('Gotowe', x, '*', y, '=', step1PaddedNum + step2Result + step4PaddedNum)

    return step1PaddedNum + step2Result + step4PaddedNum

# Przykład: 1357 x 2468 = 3349076
print('1357 * 2468 =', karatsuba(1357, 2468))
